#!/bin/bash
cd "$(dirname "$0")"
mkdir -p input
mkdir -p output

W=128
H=256
P="old-z64-1x.png"
S=8

while getopts "w:h:p:s:" opt; do
  case "$opt" in
    w) W="$OPTARG" ;;
    h) H="$OPTARG" ;;
    p) P="$OPTARG" ;;
    s) S="$OPTARG" ;;
  esac
done

for file in input/*; do
  w=$(magick identify -format "%w" "$file")
  h=$(magick identify -format "%h" "$file")

  if [ "$w" -gt "$h" ]; then
    size="${H}x${W}"
  else
    size="${W}x${H}"
  fi

  echo "Processing: $(basename "$file")"

  magick "$file" \
    -remap "${P}" \
    -filter point \
    -resize "${size}^" \
    -gravity center \
    -crop "${size}+0+0" +repage \
    -scale $((S * 100))% \
    "output/$(basename "$file")"
done
